* Title: 	figure15.do
* Version: 	23 May 2018
* Purpose: 	Produce map of prime male disability, 2015


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure15, text replace
set more off
clear all
macro drop _all

* Install maptile geography
maptile_install using dta/maptile_conspuma0010.zip, replace


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip cpuma0010 PrimeMaleD DisabilityB perwt ///
	using dta/acs_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 2014-2016 ACS
keep if year>=2014 & year<=2016

* Pool 2014-2016 ACS
replace year = 2015 if year>=2014 & year<=2016


*******************************************************************************
* (2) Construct joblessness rates by PUMA
*******************************************************************************

rename cpuma0010 conspuma0010

collapse (sum) Total = PrimeMaleD Disabled = DisabilityB ///
		 [pw=perwt], by(statefip conspuma0010)

gen Disability_Rate_2015 = 100 * (Disabled/Total)

keep statefip conspuma0010 Disability_Rate_2015

* Save dataset
compress
save output/figures/dta/figure15.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************
				
maptile Disability_Rate_2015, geo(conspuma0010) conus ///
		cutvalues(7(3)19) ///
		twopt(legend(title("Reported disability rate, percent", size(vsmall)) ///
		lab(2 "< 7") ///
		lab(3 "7 - 10") ///
		lab(4 "10 - 13") ///
		lab(5 "13 - 16") ///
		lab(6 "16 - 19") ///
		lab(7 "> 19")))


graph save output/figures/gph/figure15, replace
graph export output/figures/eps/figure15.eps, as(eps) replace
export excel using output/figures/xlsx/figure15.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
